var coeff=1.0;   // Коэффициент масштабирования веб-интерфейса
var CurrentPlaylist = null; //Выбранный плейлист
var CurrentSong = null; // Выбранный трек, индекс
var PlayingSong = null; // Воспроизводимый трек, индекс
var Albums = new Object(); // Список альбомов плейлиста  Структура: Albums(полное описание) AlbumsS (только название) Authors Years Songs<Songs,SongsLen> Playlists
var CurrentAlbum = null; //Выбранный альбом, числовой индекс    
var PlayingAlbum = null; //Воспроизводимый альбом, числовой индекс    
var Volume = null;  // Громкость 
var Position = null;  // Позиция воспроизведения
var Playing = false; // Состояние воспроизведения
var CurrentSongs = null; // Список песен выбранного альбома
var CurrentTime = null; // Текущее время воспроизведения в секундах
var PlayTimerId = null; // идентификатор таймера воспроизведения.
var Playlists = null;  // Список плейлистов
var PlaylistIndex = 0; // Последний выбранный плейлист
var PlaylistIndexNew = 0; // Выбранный в списке плейлист
var Paused = false; // Состояние паузы
var ModePlaylists = false; // Выводится список плейлистов
var ChangePosition = false; // Обрабатывется позиционирование в треке
var ViewPictures = false; //  Режим отображения картинок
var PlayingLen = null; // Длительность воспроизводимого трека
var PlayingName = null;  // Воспроизводимый трек, название
var PicturesInterval = 20;  // Интервал обновления картинок, сек.
var IsSafari = navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Chrome') == -1 && navigator.userAgent.indexOf('Android') == -1;
var timestamp = new Date().getTime();
var SavedAlbumIndex = 0;
var SavedSongIndex = 0;
var bFirst = false;
var OldViewPictures = true;
var FlagRadio = false;
var AddMode = false;

// Инициализация при загрузке
$.getJSON('?GetAlbums', ParseAlbums);
window.onblur = OnBlur;
window.onfocus = OnFocus;

function StopTimer()
{  
    if (IsSafari)   
    	return;
    if (PlayTimerId != null) 
    {
        clearInterval(PlayTimerId);
        PlayTimerId = null;
    }    
}

function SetTimer()
{
    StopTimer(); 
    if (PlayTimerId == null) 
        PlayTimerId = setInterval('PlayTimer()', 1000);  
	}

function OnBlur()
{
    StopTimer();
}

function OnFocus()
{     
   if (coeff!=1.0) 
   {
     var elm = document.getElementById('all'); 
     if (navigator.userAgent.indexOf('Firefox')!=-1) elm.style.boxShadow='none';  
     elm.style.webkitTransform = elm.style.msTransform =  elm.style.mozTransform =   elm.style.transform = 'scale('+coeff+')'; 
   }
   UpdateState();
   if(PlayTimerId == null)
        SetTimer();
}

function OnPictureMode() {
    if (ViewPictures) {

        $('#ImgBlock').css('display', 'none');
        $('#PictMode').css('display', '');
        $('#Playlists').removeClass('narrowList');
        $('#Songs').removeClass('narrowList');
        $('#SongsBlock').removeClass('narrowList');
        $('#Playlists').addClass('wideList');
        $('#Songs').addClass('wideList');
        $('#SongsBlock').addClass('wideList');
        ViewPictures = false;
    }
    else {
        $('#Playlists').removeClass('wideList');
        $('#Songs').removeClass('wideList');
        $('#SongsBlock').removeClass('wideList');
        $('#Playlists').addClass('narrowList');
        $('#Songs').addClass('narrowList');
        $('#SongsBlock').addClass('narrowList');
        $('#PictMode').css('display', 'none');
        $('#ImgBlock').css('display', '');
        $('#Image').attr('src', '?GetImage&pl=' + PlaylistIndex + '&image=' + CurrentAlbum + '&time=' + (new Date()).getTime());
        ViewPictures = true;
    }
}

function SetPlaylistSelColor(down)
{
    $.each($('#Playlists').children(), function (ind2, val) {
        if (ind2 == PlaylistIndexNew) 
        {
            if(down == true)
                 $(val).css('background-color', 'rgb(184,184,184)');
            else 
                 $(val).css('background-color', 'rgb(104,104,104)');
        }
        else
            $(val).css('background-color', 'rgb(68,68,68)');
    });
}

function OnSelectPlaylist_(data)
{   
    Playlists = data.Playlists;
    RemoveHourglass();
    $('#Playlists').empty();    
    if (Playlists != null && Playlists.length > 0) 
    {
        $.each(Playlists, function (ind, val) { var val_ = (ind == 0) ? 'Last Playlist' : val; $('#Playlists').append('<tr><td  onclick="SelectPlaylist(' + ind + ')">' + val_ + '</td></tr>'); });     
    }
    //PlaylistIndexNew = data.SelectedDirIndex;   
    SetPlaylistSelColor(false);
    $('#bOpen').attr('src', 'img/opena.png')
    $('#Albums').css('visibility', 'hidden');
    $('#Songs').css('display', 'none');
    $('#Playlists').css('display', '');    
}

function MakeHourglass()
{
    $('<img id="Hourglass" src="img/hourglass.gif">').appendTo('#SongsBlock').addClass('wait');
}

function StatusClick() {
    if (ModePlaylists == true) {
        PlaylistIndexNew = -1;
        OnSelectPlaylist(false);
    }
}

function RemoveHourglass()
{
    $('#Hourglass').remove();
}

function ReturnToSongs()
{
    $("#Input").css('display', 'none');
    $("#Filter").css('display', 'block');
    if (OldViewPictures)
        OnPictureMode();
}

function OnSelectPlaylist(add)
{
    if (ModePlaylists == false) 
    {
      if (add)
         AddMode = true;
      else
         AddMode = false;
      PlaylistIndex = PlaylistIndexNew = -1;     
      $("#Search").val(""); 
      $('option').css('display', 'block');  
      $.getJSON('?GetPlaylists&ind=-1', OnSelectPlaylist_);
      ModePlaylists = true;
      OldViewPictures = ViewPictures;
      $("#Filter").css('display', 'none');
      if (ViewPictures)
          OnPictureMode();
    }
    else
    {        
        $('#SongsBlock').scrollTop(0);
        if (PlaylistIndexNew == null)
            PlaylistIndexNew = 0;
        PlaylistIndex = PlaylistIndexNew;
        if (PlaylistIndex != -1) 
        {         
            SetPlaylistSelColor(true);
            MakeHourglass();
            if(AddMode)
                $.getJSON('?Get_Playlist&playlist=' + PlaylistIndex, ParseAlbums);
            else
                $.getJSON('?GetPlaylist&playlist=' + PlaylistIndex, ParseAlbums);
        }
        else 
        {
            $('#bOpen').attr('src', 'img/openp.png')
            ModePlaylists = false;
            $('#Albums').css('visibility', 'visible');
            $('#Songs').css('display', '');
            $('#Playlists').css('display', 'none');
            ReturnToSongs();
        }

    }     
}

function OnViewAlbum() {
    if (!Playing)
        return;    
    if (CurrentAlbum != PlayingAlbum) {
        CurrentAlbum = PlayingAlbum;
        $('#Albums')[0].selectedIndex = CurrentAlbum;
        if (Albums.Songs != null && Albums.Songs.length > 0) {
            $.getJSON('?GetSongs&album=' + CurrentAlbum, ParseSongs);
        }
    }
    $('#Image').attr('src', '?GetImage&pl=' + PlaylistIndex + '&image=' + CurrentAlbum + '&time=' + (new Date()).getTime());
    $('#SongsBlock').scrollTop(0);
}

function ProgressChange(pos)
{
    if (!Playing)
        document.getElementById('progress').value = 0;
    else 
    {
        ChangePosition = true;
        var pos2 = Math.round(pos * 232.0 / 100.0);
        PositionCommand(pos2);
        CurrentTime = PlayingLen / 1000 * pos / 100;
    }
}

function VolumeChange(vol)
{
    ChangePosition = true;
    var volume = Math.round(vol * 255.0 / 100.0);
    VolumeCommand(volume);     
}

function GetLenText(len) // Время в формате 0:00:00
{
    var Playtime = len / 1000; // sec
    var result = "";
    if(Playtime >= 3600)
				{
                    result = result + Math.round(Playtime/3600 - 0.5) + ':';					
					Playtime=Playtime%3600;
				}				
				if(Playtime >= 600)
					{
                        result = result + Math.round(Playtime/60 - 0.5);						
					  }
				else
                        result = result + '0' + Math.round(Playtime/60 - 0.5);						
				result = result  + ':';		
				var ost = Math.round(Playtime % 60 - 0.5);
				if(ost > 9)
					 result = result  + ost;		
				else
					 result = result  + '0' + ost;
		return result;
}

function ParseSongs(data) 
{
    
    var Songs = data.Songs;
    CurrentSongs = Songs;    
    $('#Songs').empty();
    if (Songs != null && Songs.length > 0) 
    {
        $.each(Songs, function (ind, val) { $('#Songs').append('<tr><td  onclick="SelectSong(' + ind + ')" ondblclick="PlayCommand2(' + ind + ')">' + val + '</td></tr>'); });
         if(Playing && CurrentAlbum == PlayingAlbum)
         {
             SelectSong(PlayingSong);           
         }
         else
         if(bFirst)
               SelectSong(SavedSongIndex);  
         else
            SelectSong(-1);
    }
    else
        CurrentSong = null;    
}

function ParseAlbums(data)
{
    RemoveHourglass();
    ReturnToSongs();
    $('#bOpen').attr('src', 'img/openp.png')
    ModePlaylists = false;
    $('#Albums').css('visibility', 'visible');
    $('#Songs').css('display', '');
    $('#Playlists').css('display', 'none');
    Albums.Albums = data.Albums;
    Albums.Authors = data.AuthorList;
    Albums.Songs = data.Songs;
    Albums.AlbumsS = data.AlbumList;
    Albums.Years = data.YearList;
    Playlists = data.Playlists;
    SavedAlbumIndex = data.SavedAlbumIndex;
    SavedSongIndex = data.SavedSongIndex;
    $('#Albums').empty();
    $('#Playlists').empty();
    $('#Songs').empty();
    if (Albums.Albums != null && Albums.Albums.length > 0) {

        CurrentAlbum = SavedAlbumIndex;
        $('#Image').attr('src', '?GetImage&pl=' + PlaylistIndex + '&image='+ CurrentAlbum + '&time=' + (new Date()).getTime());
        $.each(Albums.Albums, function (ind, val) { $('#Albums').append('<option value=' + ind + ' title="'+ val +'">' + val + '</option>'); });
        $("#Albums option[value='"+ SavedAlbumIndex  + "']").prop('selected', true);
        if (Albums.Songs != null && Albums.Songs.length > 0) 
        {
            bFirst = true;
            ParseSongs(Albums.Songs[0]);
            bFirst = false;
        }
    }
    else {
            CurrentAlbum = null;
            $('#Image').attr('src', 'img/logo.png');
         }
    if (Playlists != null && Playlists.length > 0) 
    {
        $.each(Playlists, function (ind, val) { var val_=(ind==0)? 'Last Playlist': val;$('#Playlists').append('<tr><td  onclick="SelectPlaylist('+ind+')" ondblclick="OnSelectPlaylist()">'+val_+'</td></tr>'); });
      //  SelectPlaylist(PlaylistIndex);
    }
    SelectSong(SavedSongIndex);
    UpdateState();        
}	

function ParseStd(data)
{
    var res = data.Result;
    if(res != "OK")
     DisplayError(res)
    UpdateState();
}

function PlayTimer() 
{
    if (ChangePosition)
        return;
     var len = PlayingLen;
     if(Playing)
      {
         if (!Paused)
         {
             CurrentTime = CurrentTime + 1;
             // Pictures rotator             
             if (Math.floor(CurrentTime) % PicturesInterval == 0 && CurrentAlbum == PlayingAlbum && ViewPictures)
             {
                 $('#Image').attr('src', '?GetImage&pl=' + PlaylistIndex + '&image=' + CurrentAlbum + '&time=' + (new Date()).getTime());
             }

         }
         document.getElementById('progress').value = CurrentTime * 1000 / len * 100;
         $('#lTime').text(GetLenText(CurrentTime * 1000));
         if (IsSafari) {
             current = new Date().getTime();
             if (current - timestamp > 1500) {
                 len = 0;
                 timestamp = current;
             }
         }
     }     
    if($('#lKhz').text() == '' || len /1000 - CurrentTime < 5 || $('#progress').css('visibility') == 'hidden')
        UpdateState();
     if(Playing && FlagRadio && Math.floor(CurrentTime) % 10 == 0)
     {       
        $.getJSON('?GetRadio', ParseRadio);
     }
}

function ParseRadio(data)
{
    $('#lRadio').text(data.RadioTitle);
}

function ParsePlay(data)
{
    CurrentTime = 0;
    SetTimer();
    var res = data.Result;
    if (res != "OK") 
    {
        DisplayError(res);
        Playing = false;
        $('#lTime').text(''); 
    }
    else 
    {       
        $('#lTime').text('00:00');       
        Playing = true;
    }
    UpdateState();
}

function ParseStopPlay(data)
{    
    var res = data.Result;
    if(res != "OK")
         DisplayError(res)
    Playing = false;
  
    PlayCommand();
}

function ChangeAlbum(obj)
{
  CurrentAlbum = $(obj).val();
  $('#Image').attr('src', '?GetImage&pl=' + PlaylistIndex + '&image=' + CurrentAlbum + '&time=' + (new Date()).getTime());
  $.getJSON('?GetSongs&album='+ CurrentAlbum, ParseSongs);            
}

function PlayCommand()
{    
    if(CurrentAlbum == null || CurrentSongs == null || Playing || CurrentSongs.Length == 0)
        return;  
    PlayingSong = CurrentSong; 
    $.each($('#Songs').children(), function (ind2, val) { $(val).css('background-color', 'rgb(68,68,68)'); });
    PlayingAlbum = CurrentAlbum;
     if(CurrentSong < 0 || CurrentSong > CurrentSongs.length -1)
        PlayingSong=CurrentSong = 0;
     $.getJSON('?Play&album='+ CurrentAlbum+'&song='+CurrentSong, ParsePlay);
}

function PlayCommand2(ind)
{
    CurrentSong = ind;
    $.each($('#Songs').children(), function (ind2, val) { $(val).css('background-color', 'rgb(68,68,68)'); });
    if (Playing) 
    {
        StopCommand(ParseStopPlay);
    }
    else
        PlayCommand();
}

function SelectSong(ind)
{   
    CurrentSong = ind;
    $.each($('#Songs').children(), function (ind2, val) {
        if (ind == ind2) 
            $(val).css('background-color', 'rgb(104,104,104)');
        else
            $(val).css('background-color', 'rgb(68,68,68)');
    });
}

function SelectPlaylist(ind)
{    
    if (PlaylistIndexNew != ind) 
    {
        PlaylistIndexNew = ind;
        SetPlaylistSelColor(false);                
    }
    else
    {
        SetPlaylistSelColor(true);
        MakeHourglass();
       $.getJSON('?GetPlaylists&ind=' + ind, OnSelectPlaylist_); 
    }
}

function StopCommand(parser)
{
     $('#lTime').text('');
     $('#lTotalTime').text('');
     document.getElementById('progress').value = 0;
     $.getJSON('?Stop', parser);    
}

function PositionCommand(pos)
{
    if (!Playing) 
            return;
     $.getJSON('?Position&pos='+ pos.toString(), ParseStd);    
}

function VolumeCommand(vol)
{
     $.getJSON('?SetVolume&volume='+ vol.toString(), ParseVolume);    
}

function PauseCommand()
{
    if (!Playing) 
            return;
     $.getJSON('?Pause', ParseStd);   
}

function NextCommand()
{
       if (!Playing) 
            return;
      document.getElementById('progress').value = 0;
    //  Paused = false;
      $.getJSON('?Next', ParsePlay);
}

function PrevDown()
{
   $('#bPrev').attr('src', 'img/preva.png')
}

function PrevUp()
{
   $('#bPrev').attr('src', 'img/prevp.png')
}

function StopDown()
{
   $('#bStop').attr('src', 'img/stopa.png')
}

function StopUp()
{
   $('#bStop').attr('src', 'img/stopp.png')
}

function PlayDown()
{
  // if(!Playing) 
  //  $('#bPlay').attr('src', 'img/playa.png')
}

function PlayUp()
{
   if(!Playing) 
     $('#bPlay').attr('src', 'img/playp.png')
}

function PauseDown()
{
}

function PauseUp()
{
}

function NextDown()
{
   $('#bNext').attr('src', 'img/nexta.png')
}

function NextUp()
{
   $('#bNext').attr('src', 'img/nextp.png')
}

function OpenDown()
{
   $('#bOpen').attr('src', 'img/opena.png')
}

function OpenUp()
{
   if (ModePlaylists == false) 
    $('#bOpen').attr('src', 'img/openp.png')
}

function PrevCommand()
{
    if (!Playing) 
            return;
     document.getElementById('progress').value = 0;
     $.getJSON('?Prev', ParsePlay);    
}

function HideError()
{
    $('#lError').css('display', 'none');
}

function DisplayError(error)
{
    $('#lError').text(error);
    $('#lError').css('display', 'block');
    setTimeout("HideError()", 3000);
}

function ParseVolume(data)
{
   ChangePosition = false;
}

function ParseState(data)
{
    ChangePosition = false;
    if(Volume == null)
        document.getElementById('volume').value = Volume = data.Volume * 100 / 255;
    if (!data.Playing) 
    {
        Playing = false;
        $('#lArtist').text('');
        $('#lArtist').attr('title','');
        $('#lAlbum').text('');
        $('#lAlbum').attr('title','');
        $('#lYear').text('');
        $('#lNum').text('');
        $('#lSong').text('');
        $('#lSong').attr('title','');
        $('#lRadio').text('');
        $('#lKbps').text('');
        $('#lKhz').text('');
        $('#lBit').text('');
        $('#lCh').text('');
        $('#lLength').text('');
        $('#lTime').text('');        
        $('#bPlay').attr('src', 'img/playp.png')        
        $('#bPause').attr('src', 'img/pausep.png')        
        CurrentTime = 0;
        PlayingLen = 0;
        PlayingName = "";
        document.getElementById('progress').value = 0;
    }
    else 
    {
       var new_alb = PlayingAlbum != data.Album;
       Playing = true;
       if(PlayTimerId == null) 
             SetTimer();
        PlayingAlbum = data.Album;
        PlayingSong = data.Song;
        if(PlayingAlbum == CurrentAlbum)
        {
             SelectSong(PlayingSong);
        }
         else {            
            if (new_alb)
            {
                OnViewAlbum();
                SelectSong(PlayingSong);
            }
            else
                SelectSong(-1);
        }
        $('#lArtist').text(Albums.Authors[data.Album]);
        $('#lArtist').attr('title', $('#lArtist').text());
        $('#lAlbum').text(Albums.AlbumsS[data.Album]);
        $('#lAlbum').attr('title', $('#lAlbum').text());
        $('#lYear').text(Albums.Years[data.Album]);     
        $('#lNum').text((data.Song+1).toString()+'.');
        PlayingName = data.PlayingName;
        $('#lSong').text(PlayingName);
        $('#lSong').attr('title', $('#lSong').text());
        if (data.Freq > 0 && data.Bitrate > 0) 
        {
            $('#lKbps').text(data.Bitrate);
            if (data.Freq > 1000) {
                $('#lKhz').text(data.Freq / 1000);
                $('#khz').text('MHz');
            }
            else
             {
                $('#lKhz').text(data.Freq);
                $('#khz').text('kHz');
            }
        }
        else
        {
            $('#lKbps').text('');
            $('#lKhz').text('');
        }        
        $('#lBit').text(data.Bps);
        $('#lCh').text(data.Ch);
        PlayingLen = data.PlayingLen;
        $('#lLength').text(GetLenText(PlayingLen ));        
        CurrentTime = data.Position / 1000; // sec
        $('#lTime').text(GetLenText(data.Position));         
        var progress_vis = data.ProgressVisible ? 'visible': 'hidden';
        $('#progress').css('visibility', progress_vis);        
        document.getElementById('progress').value = CurrentTime * 1000 / PlayingLen  * 100;
        $('#bPlay').attr('src', 'img/playa.png')
        if (data.Paused) 
        {
            Paused = true;
            $('#bPause').attr('src', 'img/pausea.png')
        }
        else
         {
            Paused = false;
            $('#bPause').attr('src', 'img/pausep.png')
         }
         if (data.RadioTitle.length > 0) {
             $('#lRadio').text(data.RadioTitle);
             FlagRadio = true;
             $('#lArtist').text("");
             $('#lYear').text("");
         }
         else  {
             $('#lRadio').text("");
             FlagRadio = false;
         }
    }
}

function UpdateState()
{
     $.getJSON('?State', ParseState);    
}

//Plus
function PlusDown() {
    $('#bPlus').attr('src', 'img/plusa.png')
}
function PlusUp() {
    $('#bPlus').attr('src', 'img/plusp.png')
}
function PlusCommand() {
    if (ModePlaylists == true)
    {
        $("#PlaylistName").val("");
        $("#Input").css('display', 'block');
    }
    else
    {
       OnSelectPlaylist(true);
    }
}

function MinusDown() {
    $('#bMinus').attr('src', 'img/minusa.png')
}
function MinusUp() {
    $('#bMinus').attr('src', 'img/minusp.png')
}
function MinusCommand() {
 
    if (ModePlaylists == true) {
      if (PlaylistIndexNew > 0)
        {               
            var row = $("#Playlists").children().eq(PlaylistIndexNew);       
            if(row != undefined)
            {                                               
                var cell = row.children().first();
                var text = cell.text();
                var subtext = text.substring(0, 1).trim();                
                if (text[0] != '⊞' && text[0] != '⊟' && subtext.length > 0) {
                    var ok = confirm("Do you want to remove a playlist named  '" + cell.text() + "' ?");
                    if(ok == true)
                    {
                        $("#Input").css('display', 'none');
                        PlaylistIndexNew = -1;
                        $.getJSON('?DeletePlaylist&name='+text, OnSelectPlaylist_);                               
                    }
                }              
            }                           
        }
    }
    else {
     if(CurrentAlbum == null)
     return;
     $("#Search").val("");
     OldViewPictures = false;
    $.getJSON('?DeleteAlbum&album='+ CurrentAlbum, ParseAlbums);
    }    
}

function ClearDown() {
    $('#bClear').attr('src', 'img/closea.png')
}
function ClearUp() {
    $('#bClear').attr('src', 'img/closep.png')
}
function ClearCommand() {
    $('#Search').val("");
    OnSearch();
}

function OkDown() {
    $('#bOk').attr('src', 'img/oka.png')
}
function OkUp() {
    $('#bOk').attr('src', 'img/okp.png')
}
function OkCommand() {
    var str = $('#PlaylistName').val();
    $("#Input").css('display', 'none');
    if (str.length > 0) {        
        PlaylistIndexNew = -1;
        $.getJSON('?SavePlaylist&name='+str, OnSelectPlaylist_);        
    }
}


function OnSearch()
{
    var text = $('#Search').attr('value');  
     if ( text.length == 0)
     {
        $('option').css('display', 'block');  
        return;
    }
   var l = Albums.Albums.length;
   var q = text.toLowerCase();
   var found = null;
   for (s = 0; s < l; s++) 
   {   
    var el = Albums.Albums[s];   
    var val = el.toLowerCase();   
    var ok = val.indexOf(q) > -1;
    if (ok)
     {
        $('option').eq(s).css('display', 'block');
        if (found == null)
            found = $('option').eq(s);
    }
    else
        $('option').eq(s).css('display', 'none');   
   }
   if (found != null)
    {
        found.prop('selected', true); 
        ChangeAlbum(found);     
    }
}
